local starscroller={}
local startStarCountBright=60
local startStarCountMedium=190
local startStarCountDim=300
local maxStarCountBright=210
local maxStarCountMedium=1000
local maxStarCountDim=1500
local rampDuration=60.0
local screenWidth,screenHeight=1920,1080
local brightStars={}
local mediumStars={}
local dimStars={}
local totalElapsedTime=0
local slowdownStartTime=69.5
local slowdownDuration=32.0
local function randomSquareSize()
local choices={2,3,4,5}
return choices[math.random(1,#choices)]
end
local function randomSpeed(minSpeed,maxSpeed)
return math.random(minSpeed,maxSpeed)
end
local function spawnStarRight(star,minSpeed,maxSpeed)
star.minSpeed=minSpeed
star.maxSpeed=maxSpeed
local s=randomSquareSize()
star.width=s
star.height=s
star.speed=randomSpeed(minSpeed,maxSpeed)
star.y=math.random(0,screenHeight)
local jitter=math.random(0,8)
star.x=screenWidth+jitter+star.width
end
local function seedStarInFlight(star,minSpeed,maxSpeed)
star.minSpeed=minSpeed
star.maxSpeed=maxSpeed
star.speed=randomSpeed(minSpeed,maxSpeed)
star.y=math.random(0,screenHeight)
local s=randomSquareSize()
star.width=s
star.height=s
star.x=math.random(0,screenWidth)
end
local function createStars(starTable,count,minSpeed,maxSpeed,seededOnScreen)
for i=1,count do
local star={}
if seededOnScreen then
seedStarInFlight(star,minSpeed,maxSpeed)
else
spawnStarRight(star,minSpeed,maxSpeed)
end
table.insert(starTable,star)
end end
function starscroller.load()
math.randomseed(os.time())
createStars(brightStars,startStarCountBright,320,390,true)
createStars(mediumStars,startStarCountMedium,140,190,true)
createStars(dimStars,startStarCountDim,40,80,true)
end
local function calculateslowedspeed(originalSpeed,elapsedTime)
if elapsedTime<slowdownStartTime then
return originalSpeed
elseif elapsedTime>=slowdownStartTime+slowdownDuration then
return 0
else
local slowdownElapsed=elapsedTime-slowdownStartTime
local t=slowdownElapsed/slowdownDuration
return originalSpeed*(1-t)
end end
local function updatestars(starTable,dt,elapsedTime)
for _,star in ipairs(starTable) do
local slowedSpeed=calculateslowedspeed(star.speed,elapsedTime)
star.x=star.x-slowedSpeed*dt
if star.x<-star.width then
spawnStarRight(star,star.minSpeed,star.maxSpeed)
end end end
local function handleStarRamp()
local t=math.min(totalElapsedTime/rampDuration,1.0)
local targetBright=math.floor(startStarCountBright+(maxStarCountBright-startStarCountBright)*t)
local targetMedium=math.floor(startStarCountMedium+(maxStarCountMedium-startStarCountMedium)*t)
local targetDim=math.floor(startStarCountDim+(maxStarCountDim-startStarCountDim)*t)
if #brightStars<targetBright then createStars(brightStars,targetBright-#brightStars,320,390,false) end
if #mediumStars<targetMedium then createStars(mediumStars,targetMedium-#mediumStars,140,190,false) end
if #dimStars<targetDim then createStars(dimStars,targetDim-#dimStars,40,80,false) end
end
function starscroller.update(dt)
totalElapsedTime=totalElapsedTime+dt
handleStarRamp()
updatestars(brightStars,dt,totalElapsedTime)
updatestars(mediumStars,dt,totalElapsedTime)
updatestars(dimStars,dt,totalElapsedTime)
end
function starscroller.draw()
love.graphics.setColor(1,1,1,0.1)
for _,star in ipairs(dimStars) do
love.graphics.rectangle("fill",math.floor(star.x),math.floor(star.y),star.width,star.height)
end
love.graphics.setColor(1,1,1,0.3)
for _,star in ipairs(mediumStars) do
love.graphics.rectangle("fill",math.floor(star.x),math.floor(star.y),star.width,star.height)
end
love.graphics.setColor(1,1,1,0.8)
for _,star in ipairs(brightStars) do
love.graphics.rectangle("fill",math.floor(star.x),math.floor(star.y),star.width,star.height)
end end
return starscroller
